/* 
 *  IBM eServer eHCA Infiniband device driver for Linux on POWER
 *   
 *  Userspace functions
 *
 *  Authors: Khadija Souissi <souissik@de.ibm.com>
 *           Christoph Raisch <raisch@de.ibm.com>
 *
 *  Copyright (c) 2005 IBM Corporation
 *    
 *  All rights reserved.
 *
 *  This source code is distributed under a dual license of GPL v2.0 and OpenIB 
 *  BSD. 
 *
 * OpenIB BSD License
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met: 
 *
 * Redistributions of source code must retain the above copyright notice, this 
 * list of conditions and the following disclaimer. 
 *
 * Redistributions in binary form must reproduce the above copyright notice, 
 * this list of conditions and the following disclaimer in the documentation 
 * and/or other materials
 * provided with the distribution. 
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
 * IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 *  $Id: ehca_utools.h,v 1.2 2006/02/21 17:15:47 nguyen Exp $
 */
 
#ifndef __EHCA_UTOOL_H__
#define __EHCA_UTOOL_H__

#include <stdio.h>

#include <linux/types.h>
#include <linux/err.h>
#define u64 __u64
#define u32 __u32
#define u16 __u16
#define u8 __u8

#define unlikely(x) __builtin_expect(!!(x), 0)

/* defines for EDEBs */
extern int libehca_trlevel;
extern FILE *libehca_fh;

/* checks if debug is on for the given level
 * caller's module must have this decl: extern int libehca_trlevel;
 */
#ifdef EDEB_NO_TRACE
#define IS_EDEB_ON(level) (1==0)
#define EDEB_GENERIC(level,idstring,format,args...) \
while (1==0) { \
 \
 fprintf(libehca_fh,"%s " idstring "%p "format "\n", __func__,  ##args); \
} 
#else /* EDEB_NO_TRACE */
#define IS_EDEB_ON(level) (level<=libehca_trlevel)

#define EDEB_GENERIC(level,idstring,format,args...) \
do { \
 if (unlikely(level<=libehca_trlevel))\
 fprintf(libehca_fh,"%s " idstring " "format "\n", __func__,  ##args); \
} while (1==0)
#endif /* EDEB_NO_TRACE */

#define EDEB(level,format,args...) \
        EDEB_GENERIC(level,"",format,##args)
#define EDEB_EN(level,format,args...) \
        EDEB_GENERIC(level,">>>",format,##args)
#define EDEB_EX(level,format,args...) \
        EDEB_GENERIC(level,"<<<",format,##args)
#define EDEB_ERR(level,format,args...) \
        EDEB_GENERIC(level,"HCAD_ERROR ",format,##args)

/**
 * EDEB macro to dump a memory block, whose length is n*8 bytes.
 * Each line has the following layout:
 * <format string> adr=X ofs=Y <8 bytes hex> <8 bytes hex>
 */
#ifndef __PPC64__
#define FORMAT_2U64 "%016llx %016llx"
#else
#define FORMAT_2U64 "%016lx %016lx"
#endif
#define EDEB_DMP(level,adr,len,format,args...) \
        do { \
                unsigned int x; \
		unsigned int l = (unsigned int)(len); \
                unsigned char *deb = (unsigned char*)(adr); \
		for (x = 0; x < l; x += 16) { \
		        EDEB(level, format " adr=%p ofs=%04x " FORMAT_2U64, \
			     ##args, deb, x, \
			     *((u64 *)&deb[0]), *((u64 *)&deb[8])); \
			deb += 16; \
		} \
        } while (0)

/* define a bitmask, little endian version */
#define EHCA_BMASK(pos,length) (((pos)<<16)+(length))
/* define a bitmask, the ibm way... */
#define EHCA_BMASK_IBM(from,to) (((63-to)<<16)+((to)-(from)+1))
/* internal function, don't use */
#define EHCA_BMASK_SHIFTPOS(mask) (((mask)>>16)&0xffff)
/* internal function, don't use */
#define EHCA_BMASK_MASK(mask) (0xffffffffffffffffULL >> ((64-(mask))&0xffff))
/** return value shifted and masked by mask\n
    variable|=HCA_BMASK_SET(MY_MASK,0x4711) ORs the bits in variable\n
    variable&=~HCA_BMASK_SET(MY_MASK,-1) clears the bits from the mask 
    in variable
 */
#define EHCA_BMASK_SET(mask,value) \
        ((EHCA_BMASK_MASK(mask) & ((u64)(value)))<<EHCA_BMASK_SHIFTPOS(mask))

#include "ehca_qes.h"

#define container_of(ptr, type, member) ({			\
        const typeof( ((type *)0)->member ) *__mptr = (ptr);	\
        (type *)( (char *)__mptr - offsetof(type,member) );})

#define PARANOIA_MODE
#ifdef PARANOIA_MODE
#define EHCA_CHECK_ADR_P(adr)  \
        if (adr==0) {\
               EDEB_ERR(4, "adr=%p check failed line %i", adr,__LINE__); \
               return ERR_PTR(-EFAULT); }

#define EHCA_CHECK_ADR(adr)  \
        if (adr==0) {\
               EDEB_ERR(4, "adr=%p check failed line %i", adr,__LINE__); \
               return -EFAULT; }

#define EHCA_CHECK_CQ(cq)  \
        if (cq==0) {\
               EDEB_ERR(4, "cq=%p check failed", cq); \
               return -EFAULT; }

#define EHCA_CHECK_CQ_P(cq)  \
        if (cq==0) {\
               EDEB_ERR(4, "cq=%p check failed", cq); \
               return ERR_PTR(-EFAULT); }

#define EHCA_CHECK_QP(qp)  \
        if (qp==0) {\
               EDEB_ERR(4, "qp=%p check failed", qp); \
               return -EFAULT; }

#define EHCA_CHECK_QP_P(qp)  \
        if (qp==0) {\
               EDEB_ERR(4, "qp=%p check failed", qp); \
               return ERR_PTR(-EFAULT); }

#else
#define EHCA_CHECK_ADR_P(adr)

#define EHCA_CHECK_ADR(adr)

#define EHCA_CHECK_CQ(cq)

#define EHCA_CHECK_CQ_P(cq)

#define EHCA_CHECK_QP(qp)

#define EHCA_CHECK_QP_P(qp)
#endif

#define be64_to_cpu(x) (x)

#define mftb() ({ unsigned long rval; \
                  asm volatile("mftb %0" : "=r" (rval)); rval; })

#define asm_sync_mem() __asm__ __volatile__ ("sync" : : : "memory")

#endif /* __EHCA_UTOOL_H__ */
